<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:strip-space elements="*"/>
    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <xsl:choose>
            <xsl:when test="$xslShowHelp = 'true'">
                <xsl:call-template name="StyleSheetHelp"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="InRoads/GeometryProject">
                    <xsl:text/>
                    <xsl:text>* BENTLEY SMĚROVÉ ŘEŠENÍ PŘEHLED&#xd;</xsl:text>
                    <xsl:text>* &#xd;</xsl:text>
                    <xsl:for-each select="HorizontalAlignment">
                        <xsl:text>* Název trasy: </xsl:text><xsl:value-of select="@name"/><xsl:text>&#xd;</xsl:text>
                        <xsl:text>* Popis trasy: </xsl:text><xsl:value-of select="@description"/><xsl:text>&#xd;</xsl:text>
                        <xsl:text>* Styl trasy: </xsl:text><xsl:value-of select="@style"/><xsl:text>&#xd;</xsl:text>
                        <xsl:text>* &#xd;</xsl:text>
                        <xsl:value-of select="cif:columnFormat('STANIČENÍ',47)"/>
                        <xsl:value-of select="cif:columnFormat('Y',20)"/>
                        <xsl:value-of select="cif:columnFormat('X',20)"/>
                        <xsl:text>&#xd;</xsl:text>
                        <xsl:for-each select="HorizontalElements">
                            <xsl:apply-templates/>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="HorizontalLine">
        <xsl:text>Prvek: Přímá</xsl:text>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(Start/@pointType)),15)"/>
        <xsl:text>(</xsl:text><xsl:value-of select="cif:columnFormat(string(Start/@name),10)"/><xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName)), 20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(Start/@northing)), 20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(Start/@easting)), 20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <xsl:value-of select="cif:columnFormat('StanPuv',15)"/>
                <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(@backStation), string(@backEquation)), 32)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@northing)), 20)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@easting)), 20)"/>
                <xsl:text>&#xd;</xsl:text>
                <xsl:value-of select="cif:columnFormat('StanNove',15)"/>
                <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(@aheadStation), string(@aheadEquation)),32)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@northing)),20)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@easting)),20)"/>
                <xsl:text>&#xd;</xsl:text>
            </xsl:for-each>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(End/@pointType)),15)"/>
        <xsl:text>(</xsl:text><xsl:value-of select="cif:columnFormat(string(End/@name),10)"/><xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(End/@northing)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(End/@easting)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Směr tečny:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:directionFormat(number(@direction)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Délka tečny:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@length)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:text>&#xd;</xsl:text>
    </xsl:template>

    <xsl:template match="HorizontalCircle">
        <xsl:text>Prvek: Oblouk</xsl:text>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(Start/@pointType)),15)"/>
        <xsl:text>(</xsl:text><xsl:value-of select="cif:columnFormat(string(Start/@name),10)"/><xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName)), 20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(Start/@northing)), 20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(Start/@easting)), 20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="PI">
            <xsl:value-of select="cif:columnFormat(cif:pointType(string(PI/@pointType)),15)"/>
            <xsl:text>(</xsl:text><xsl:value-of select="cif:columnFormat(string(PI/@name),10)"/><xsl:text>)</xsl:text>
            <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(PI/station/@externalStation), string(PI/station/@externalStationName)),20)"/>
            <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(PI/@northing)),20)"/>
            <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(PI/@easting)),20)"/>
            <xsl:text>&#xd;</xsl:text>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(Center/@pointType)),15)"/>
        <xsl:text>(</xsl:text><xsl:value-of select="cif:columnFormat(string(Center/@name),10)"/><xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(Center/@northing)),40)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(Center/@easting)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <xsl:value-of select="cif:columnFormat('StanPuv',15)"/>
                <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(@backStation), string(@backEquation)), 32)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@northing)), 20)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@easting)), 20)"/>
                <xsl:text>&#xd;</xsl:text>
                <xsl:value-of select="cif:columnFormat('StanNove',15)"/>
                <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(@aheadStation), string(@aheadEquation)),32)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@northing)),20)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@easting)),20)"/>
                <xsl:text>&#xd;</xsl:text>
            </xsl:for-each>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(End/@pointType)),15)"/>
        <xsl:text>(</xsl:text><xsl:value-of select="cif:columnFormat(string(End/@name),10)"/><xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(End/@northing)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(End/@easting)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Poloměr:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@radius)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Úhel:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:angularFormat(number(@delta)),20)"/>
        <xsl:if test="@rotationDirection='cw'"><xsl:text> Vpravo</xsl:text></xsl:if>
        <xsl:if test="@rotationDirection='ccw'"><xsl:text> Vlevo</xsl:text></xsl:if>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="@curvatureDefinition = 'arc'">
            <xsl:value-of select="cif:columnFormat('Stupeň křivosti(Oblouk):',27)"/>
        </xsl:if>
        <xsl:if test="@curvatureDefinition = 'chord'">
            <xsl:value-of select="cif:columnFormat('Stupeň křivosti(Tětiva):',27)"/>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:angularFormat(number(@degreeOfCurve)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Délka:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@length)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Tečna:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@tangentLength)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Tětiva:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@chord)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Střední pořadnice:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@middleOrdinate)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('zo:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@externalDistance)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Směr tečny:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:directionFormat(number(@tangentialDirectionStart)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Vstupní radiální směr:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:directionFormat(number(@radialDirectionStart)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Směr tětivy:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:directionFormat(number(@chordDirection)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Výstupní radiální směr:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:directionFormat(number(@radialDirectionEnd)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Směr tečny:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:directionFormat(number(@tangentialDirectionEnd)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:text>&#xd;</xsl:text>
    </xsl:template>

    <xsl:template match="HorizontalSpiral">
        <xsl:text>Prvek: </xsl:text>
        <xsl:choose>
            <xsl:when test="@compound = 'false'">
                <xsl:value-of select="@type"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Mezilehlá </xsl:text>
                <xsl:value-of select="@type"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(Start/@pointType)),15)"/>
        <xsl:text>(</xsl:text><xsl:value-of select="cif:columnFormat(string(Start/@name),10)"/><xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName)), 20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(Start/@northing)), 20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(Start/@easting)), 20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(PI/@pointType)),15)"/>
        <xsl:text>(</xsl:text><xsl:value-of select="cif:columnFormat(string(PI/@name),10)"/><xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(PI/station/@externalStation), string(PI/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(PI/@northing)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(PI/@easting)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="StationEquation">
            <xsl:for-each select="StationEquation">
                <xsl:value-of select="cif:columnFormat('StanPuv',15)"/>
                <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(@backStation), string(@backEquation)), 32)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@northing)), 20)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@easting)), 20)"/>
                <xsl:text>&#xd;</xsl:text>
                <xsl:value-of select="cif:columnFormat('StanNove',15)"/>
                <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(@aheadStation), string(@aheadEquation)),32)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@northing)),20)"/>
                <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(GeometryPoint/@easting)),20)"/>
                <xsl:text>&#xd;</xsl:text>
            </xsl:for-each>
        </xsl:if>
        <xsl:value-of select="cif:columnFormat(cif:pointType(string(End/@pointType)),15)"/>
        <xsl:text>(</xsl:text><xsl:value-of select="cif:columnFormat(string(End/@name),10)"/><xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnFormat(cif:stationFormat(number(End/station/@externalStation), string(End/station/@externalStationName)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(End/@northing)),20)"/>
        <xsl:value-of select="cif:columnFormat(cif:ordinateFormat(number(End/@easting)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Vstupní poloměr:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@startRadius)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Výstupní poloměr:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@endRadius)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Délka:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@length)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Úhel:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:angularFormat(number(@thetaAngle)),20)"/>
        <xsl:if test="@rotationDirection='cw'"> Vpravo</xsl:if>
        <xsl:if test="@rotationDirection = 'ccw'"> Vlevo</xsl:if>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Parametr:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@aConstant)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Dlouhá tečna Xm:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@longTangent)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Krátká tečna St:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@shortTangent)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Dlouhá tětiva:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@longChord)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('X:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@xs)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Y:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@ys)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('dR:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@p)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Xs:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:distanceFormat(number(@ks)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Směr tečny:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:directionFormat(number(@tangentialDirectionStart)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Vstupní radiální směr:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:directionFormat(number(@radialDirectionStart)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Směr tětivy:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:directionFormat(number(@chordDirection)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Výstupní radiální směr:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:directionFormat(number(@radialDirectionEnd)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat('Směr tečny:',27)"/>
        <xsl:value-of select="cif:columnFormat(cif:directionFormat(number(@tangentialDirectionEnd)),20)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:text>&#xd;</xsl:text>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
       <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat nejméně jeden Civil prvek směrové geometrie.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
